<?php

$this->pageTitle = Yii::app()->name . ' - Panel nauczyciela';

$this->breadcrumbs = array(
	'Klasy'=>array('classes'),
	'Klasa '.$class->nazwa
);


Yii::app()->clientScript->registerScript('form', '

', CClientScript::POS_READY);

?>
<h1>Klasa <?php echo $class->nazwa ?></h1>

<div style="padding-bottom:10px">
	<b>Lekcja</b>
	<?php echo empty($tura) ? '<i>brak</i>' : '#' . $tura->idLekcji . ' (' . ($tura->isActive ? 'trwa' : 'zakończona') . ')' ?>
</div>

<?php if(Yii::app()->user->hasFlash('registartionStarted')): ?>
	<div class="flash-success">
		<?php echo Yii::app()->user->getFlash('registartionStarted'); ?>
	</div>
<?php endif; ?>

<h3>Firmy</h3>

<?php

	$companyDataProvider = $companies->search();
	$companyDataProvider->setPagination(false);

	$this->widget('zii.widgets.grid.CGridView', array(
		'id'=>'lista-firm',
		'htmlOptions' => array('class' => 'tDefault'),
		'dataProvider'=>$companyDataProvider,
		'filter'=>$companies,
		'columns'=>array(
			'imieNazwisko'=>array(
				'header'=>'Członkowie',
				'value'=>'$data->getUserNames()',
			),
			array(
				'name'=>'dziedzinaGlowna.nazwa',
				'header'=>'Dziedzina główna'
			),
			'nazwa',
			array(
				'header'=>'Akcje',
				'value'=>'"<a class=\"buttonS bDefault\" href=\"".Yii::app()->createUrl(\'teacher/main/company\',array(\'id\'=>$data->id))."\">Zobacz szczegóły</a>"',
				'type'=>'raw'
			)
		),
	));
?>

<h3>Uczniowie</h3>

<?php

	$studentsDataProvider = $students->search();
	$studentsDataProvider->setPagination(false);

	$this->widget('application.modules.teacher.widgets.customgrid.CustomGridView', array(
		'id'=>'lista-uczniow',
		'htmlOptions' => array('class' => 'tDefault'),
		'dataProvider'=>$studentsDataProvider,
		'filter'=>$students,
		'columns'=>array(
			'nazwisko',
			'imie',
			'email',
			array(
				'header'=>'Firma',
				'name'=>'firma.nazwa'
			),
			array(
				'value'=>'"<a class=\"buttonS bDefault\" href=\"".Yii::app()->createUrl(\'teacher/main/student\',array(\'id\'=>$data->id))."\">Zobacz szczegóły</a>"',
				'type'=>'raw'
			)
		),
	));
?>

<script type="text/javascript">
(function(){
	$(document).on('change', '.changeAbscence', function(){
		var selected = $(this).prop('checked');
		var studentId = $(this).attr('studentId');
		$('.changeAbscence').prop('disabled', true);
		$.ajax({
			type: 'POST',
			url: <?php echo json_encode(Yii::app()->createUrl('/teacher/main/markStudentPresence')) ?>,
			data: { studentId: studentId, present: selected ? 1 : 0 },
			success: function(data) {
				if (data.error)
					$(this).prop('checked', !selected);
			},
			error: function() {
				$(this).prop('checked', !selected);
			},
			complete: function() {
				$('.changeAbscence').prop('disabled', false);
				$(this).prop('checked', !selected);
			}
		});
	});
	
})();
</script>

<a  class="buttonS bLightBlue " href="<?php echo $this->createUrl('registrationStart',array('id'=>$class->id)); ?>">Rozpocznij rejestrację do tej klasy</a>